package com.hero.ui.dialog;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.HeroDesigner;
import com.hero.objects.talents.CustomTalent;
import com.hero.ui.widgets.LevelTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CustomTalentDialog extends GenericDialog {

	private static final long serialVersionUID = 4881997272334620377L;

	protected JLabel rollLbl;

	protected LevelTF rollTF;

	public CustomTalentDialog(CustomTalent pow, boolean isNew, boolean isPower) {
		super(pow, isNew, isPower);
		init();
	}

	@Override
	protected JPanel getTopPanel() {
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);

		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridwidth = 3;
		gbc.weightx = 0;
		equipmentPanel.add(carriedCB, gbc);
		gbc.gridy++;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridwidth = 1;
		equipmentPanel.add(weightLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		equipmentPanel.add(weightTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 1;
		equipmentPanel.add(new JLabel(HeroDesigner.getInstance().getPrefs()
				.isMetric() ? "kg" : "lbs"), gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.weightx = 0;
		equipmentPanel.add(priceLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		if (HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix()) {
			gbc.gridwidth = 2;
			gbc.weightx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.insets = new Insets(2, 0, 5, 2);
			JPanel pricePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
			pricePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
			pricePanel.add(new JLabel(HeroDesigner.getActiveHero().getRules()
					.getEquipmentCostUnits()));
			pricePanel.add(priceTF);
			equipmentPanel.add(pricePanel, gbc);
			gbc.insets = new Insets(2, 5, 5, 2);
		} else {
			gbc.gridwidth = 2;
			gbc.weightx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.insets = new Insets(2, 0, 5, 2);
			JPanel pricePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
			pricePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
			pricePanel.add(priceTF);
			pricePanel.add(new JLabel(HeroDesigner.getActiveHero().getRules()
					.getEquipmentCostUnits()));
			equipmentPanel.add(pricePanel, gbc);
			gbc.insets = new Insets(2, 5, 5, 2);
		}
		equipmentPanel.setBorder(BorderFactory
				.createTitledBorder("Equipment Info."));

		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);

		JPanel panel = new JPanel(new GridBagLayout());
		panel.add(nameLbl, gbc);
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridwidth = 2;
		panel.add(nameTF, gbc);
		gbc.gridy = 20;
		gbc.gridwidth = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridx = 0;
		panel.add(displayLbl, gbc);
		gbc.gridy = 25;
		if (object.getOptions().size() > 0) {
			panel.add(optionsLbl, gbc);
		}
		gbc.gridy = 30;
		panel.add(levelsLbl, gbc);
		gbc.gridy = 31;
		panel.add(rollLbl, gbc);

		gbc.gridy = 20;
		gbc.gridx = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		gbc.gridwidth = 2;
		panel.add(displayTF, gbc);
		gbc.gridy = 25;
		if (object.getOptions().size() > 0) {
			panel.add(optionsCB, gbc);
		}
		gbc.gridy = 30;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(levelTF, gbc);
		gbc.gridy = 31;
		panel.add(rollTF, gbc);
		if (object.isUserInput()) {
			gbc.gridy = 40;
			gbc.gridx = 0;
			gbc.gridwidth = 1;
			gbc.anchor = GridBagConstraints.EAST;
			gbc.fill = GridBagConstraints.NONE;
			gbc.weightx = 0;
			panel.add(inputLbl, gbc);
			gbc.gridx = 1;
			gbc.fill = GridBagConstraints.HORIZONTAL;
			gbc.weightx = 1;
			gbc.gridwidth = 2;
			panel.add(exampleCombo, gbc);
		}
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridwidth = 1;
		gbc.weightx = 0;
		gbc.gridy = 99;
		gbc.gridx = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		if (object.isEquipment()) {
			panel.add(equipmentPanel, gbc);
		}

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		rollTF.addPropertyChangeListener("Level", new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				((CustomTalent) object).setRoll(rollTF.getCurrent());
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		levelsLbl.setText("Cost:");
		rollLbl = new JLabel("Roll (0 for none):");
		rollTF = new LevelTF(((CustomTalent) object).getRollValue(), 99, 0);
	}

	@Override
	public void updateValues() {
		super.updateValues();
	}
}